/*
 * Decompiled with CFR 0.152.
 */
package BryceImages.ColorCalculators.RayMarching;

import BryceImages.ColorCalculators.RayMarching.BryceMath;
import BryceImages.ColorCalculators.RayMarching.Vector;
import BryceImages.Rendering.ColorCalculator;
import java.awt.Color;

public abstract class Geometry
extends BryceMath
implements Comparable<Geometry> {
    public double myReflect = 0.0;
    public Color myColor = Geometry.Color_hsv(0.0, 100.0, 100.0);
    public ColorCalculator cc = null;
    public double minDist = -1.0;
    public double startDist = -1.0;
    public boolean distChanged;
    public Vector u = new Vector(1.0, 0.0, 0.0);
    public Vector v = new Vector(0.0, 1.0, 0.0);
    public Vector n = new Vector(0.0, 0.0, 1.0);

    public double DE(Vector z, Vector dz) {
        return this.DE(z);
    }

    public abstract double DE(Vector var1);

    @Override
    public int compareTo(Geometry g) {
        if (this.minDist - g.minDist > 0.0) {
            return 1;
        }
        return -1;
    }

    public Color getColor(Vector z, double finalLighting) {
        Color c = this.cc != null ? this.cc.getColor(this.getComponent(z, this.u), this.getComponent(z, this.v)) : this.myColor;
        return Geometry.weightedAverageColor(Color.black, c, finalLighting);
    }

    public void setColorCalculator(ColorCalculator cc_in) {
        this.cc = cc_in;
    }

    public double reflectivity() {
        return this.myReflect;
    }

    public void setColor(Color c) {
        this.myColor = c;
    }

    public void setReflectivity(double in) {
        this.myReflect = in;
    }

    public void createCoordinateSystem(Vector n) {
        Vector temp = new Vector(0.0, 0.0, 1.0);
        if (temp.sub(n = n.norm()).mag() == 0.0) {
            temp = new Vector(0.1, 0.0, 1.0);
        } else if (temp.add(n).mag() == 0.0) {
            temp = new Vector(0.1, 0.0, -1.0);
        }
        this.v = n.cross(temp);
        this.u = this.v.cross(n);
        this.u = this.u.norm();
        this.v = this.v.norm();
        this.n = n.norm();
    }

    public double getComponent(Vector in, Vector unitCoordinateVector) {
        return in.proj(unitCoordinateVector).mag();
    }
}

